import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.ServerSocket;

import java.sql.*;

public class gateway {

  private int port = 4004;
  private ServerSocket serverSocket;
  static final String dbURL = "jdbc:mysql://localhost/todo?user=root&password=ms123aze";
  private static final int ID_CHARGE = 0;
  private static final int ID_MODIFIE = 2;

  public gateway() throws ClassNotFoundException {
    Class.forName("org.gjt.mm.mysql.Driver");
  }

  public void acceptConnections() {
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      System.err.println("Erreur");
      e.printStackTrace();
      System.exit(0);
    }
    while (true) {
      try {
        Socket newConnection = serverSocket.accept();
        ServerThread st = new ServerThread(newConnection);
        new Thread(st).start();
      } catch (IOException ioe) {
        System.err.println("Impossible d'accepter la connexion entrante");
      }
    }
  }
    
  public static void main(String args[]) {
    gateway server = null;
    try {
      server = new gateway();
    } catch (ClassNotFoundException e) {
      System.out.println("Impossible de charger le driver JDBC");
      e.printStackTrace();
      System.exit(1);
    }

    server.acceptConnections();
  }

  class ServerThread implements Runnable {
    private Socket socket;
    private BufferedReader datain;
    private BufferedWriter dataout;

    public ServerThread(Socket socket) {
      this.socket = socket;
    }

    public void run() {
      String line = null;
      try {
        datain = new BufferedReader(new InputStreamReader (socket.getInputStream()));
        dataout = new BufferedWriter(new OutputStreamWriter (socket.getOutputStream()));
      } catch (IOException e) {
        return;
      }
      byte[] ba = new byte[1024];
      int op = -1;
      try {
        line = datain.readLine();
        op = Integer.parseInt(line);
        switch (op) {
          case ID_CHARGE:
            charge (dataout);
            break;
          case ID_MODIFIE:
            modifie (datain);
            break;
          default:
            break;
        }
        socket.close();
      } catch (IOException e) {
      }
    }

    private void modifie (BufferedReader br) 
        throws IOException {
      Connection dbConn = null;
      try {
        dbConn = DriverManager.getConnection(dbURL);
        String update = "UPDATE todo SET avancement = ? WHERE action = ?";
        PreparedStatement stmt = dbConn.prepareStatement(update);
        while (true) {
          String line = br.readLine();
          if (line.length() == 0) break;
          int ix = line.indexOf ("\t");
          String action = line.substring (0, ix);
          int avancement = Integer.parseInt (line.substring (ix + 1));
          stmt.setInt (1, avancement);
          stmt.setString (2, action);
          stmt.executeUpdate();
        }
      }
      catch (SQLException e) {
      }
      finally {
        if (dbConn != null) {
          try {
            dbConn.close();
          } catch (SQLException e) {
          }
        }
      }
    }

    private void charge (BufferedWriter bw)
        throws IOException {
      Connection dbConn = null;
      try {
        dbConn = DriverManager.getConnection(dbURL);
        Statement stmt = dbConn.createStatement();
        String query = "SELECT * FROM todo";
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
          StringBuffer sb = new StringBuffer();
          sb.append(rs.getString(1));
          sb.append("\t");
          sb.append(rs.getString(2));
          sb.append('\n');
          dataout.write(sb.toString());
        }
        dataout.write("\n");
        dataout.flush();
      } catch (SQLException e) {
      }
      finally {
        try {
          dbConn.close();
        }
        catch (SQLException e) {
        }
      }
    }
  }
}
